/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.searchguard.sgctl.SgctlConfig;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="connect", description={"Tries to connect to a cluster and persists this connection for subsequent commands"})
public class Connect
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="0..1", description={"Name of the server to connect to."})
    String server;

    @Override
    public Integer call() {
        SearchGuardRestClient client = this.getClient();
        try {
            SgctlConfig.Cluster cluster = new SgctlConfig.Cluster(client.getHttpHost().getHostName(), client.getHttpHost().getPort(), client.getTlsConfig());
            String clusterConfigId = this.getSelectedClusterId();
            if (clusterConfigId == null) {
                clusterConfigId = this.getHost();
            }
            cluster.setClusterId(clusterConfigId);
            cluster.write(this.getConfigDir());
            this.writeSelectedClusterId(clusterConfigId);
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException e) {
                System.err.println(e.getMessage());
                if (this.debug) {
                    e.printStackTrace();
                }
                return 1;
            }
        }
    }

    @Override
    protected String getHost() {
        if (this.host != null) {
            return this.host;
        }
        return this.server;
    }
}

