/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands.special;

import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="move-sg-index", description={"Moves the searchguard index to its new-style name"})
public class MoveSearchGuardIndexCommand
extends ConnectingCommand
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            if (this.debug || this.verbose) {
                System.out.println("Moving searchguard index to new-style location");
            }
            BasicResponse response = client.post("/_searchguard/config/migrate_index").parseResponseBy(BasicResponse::new);
            System.out.println(response.getMessage());
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (InvalidResponseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (FailedConnectionException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ServiceUnavailableException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
    }
}

