/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.floragunn.codova.documents.Format;
import java.nio.charset.Charset;

public class ContentType {
    private final String contentTypeString;
    private final String mediaType;
    private final Format format;
    private final Charset charset;

    ContentType(String contentTypeString, String mediaType, Format format, Charset charset) {
        this.contentTypeString = contentTypeString;
        this.mediaType = mediaType;
        this.format = format;
        this.charset = charset;
    }

    public static ContentType parseHeader(String header) throws Format.UnknownDocTypeException {
        if (header == null) {
            return null;
        }
        int paramSeparator = header.indexOf(59);
        if (paramSeparator == -1) {
            return new ContentType(header, header, Format.getByMediaType(header), null);
        }
        String mediaType = header.substring(0, paramSeparator).trim();
        int charSetPos = header.indexOf("charset=", paramSeparator);
        if (charSetPos == -1) {
            return new ContentType(header, mediaType, Format.getByMediaType(mediaType), null);
        }
        int nextSeparator = header.indexOf(59, charSetPos);
        return new ContentType(header, mediaType, Format.getByMediaType(mediaType), Charset.forName(header.substring(charSetPos + 8, nextSeparator != -1 ? nextSeparator : header.length())));
    }

    public Format getFormat() {
        return this.format;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        return this.contentTypeString;
    }

    public String getMediaType() {
        return this.mediaType;
    }
}

