/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.client.api.ConfigType;
import com.floragunn.searchguard.sgctl.client.api.GetBulkConfigResponse;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="get-config", description={"Retrieves Search Guard configuration from the server to local files"})
public class GetConfig
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-o", "--output"}, required=true, arity="1", description={"Directory to write configuration to"})
    File outputDir;

    @Override
    public Integer call() {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            if (this.debug || this.verbose) {
                System.out.println("Retrieving Search Guard configuration");
            }
            GetBulkConfigResponse response = client.getConfigBulk();
            if (!this.outputDir.exists()) {
                if (this.debug || this.verbose) {
                    System.out.println("Creating directory " + String.valueOf(this.outputDir));
                }
                if (!this.outputDir.mkdirs()) {
                    throw new SgctlException("Could not create directory " + String.valueOf(this.outputDir));
                }
            }
            for (GetBulkConfigResponse.ConfigDocument config : response) {
                if (!config.isExists() && config.getConfigType() != ConfigType.CONFIG_VARS) continue;
                File outputFile = new File(this.outputDir, config.getConfigType().getFileName());
                StringBuilder header = new StringBuilder();
                header.append("# sg_" + config.getConfigType().getApiName());
                header.append(" v:" + response.getSearchGuardVersion());
                if (this.getConnectedClusterName() != null) {
                    header.append(" cluster:" + this.getConnectedClusterName());
                }
                if (config.getEtag() != null) {
                    header.append(" etag:" + config.getEtag());
                }
                header.append("\n");
                try {
                    String result = String.valueOf(header) + config.getContent().toYamlString();
                    Files.asCharSink(outputFile, Charsets.UTF_8, new FileWriteMode[0]).write(result);
                }
                catch (IOException e) {
                    throw new SgctlException("Error while writing " + String.valueOf(outputFile) + ": " + e.getMessage(), e);
                }
            }
            System.out.println("Wrote configuration to " + String.valueOf(this.outputDir));
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (InvalidResponseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (FailedConnectionException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ServiceUnavailableException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
    }
}

