/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.client;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocUtils;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.PreconditionFailedException;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.client.api.AuthInfoResponse;
import com.floragunn.searchguard.sgctl.client.api.GetBulkConfigResponse;
import com.floragunn.searchguard.sgctl.client.api.GetSgLicenseResponse;
import com.floragunn.searchguard.sgctl.client.api.GetUserResponse;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class SearchGuardRestClient
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(SearchGuardRestClient.class.getName());
    private final HttpHost httpHost;
    private final TLSConfig tlsConfig;
    private CloseableHttpClient client;
    private boolean debug;

    public SearchGuardRestClient(HttpHost httpHost, TLSConfig tlsConfig) {
        this(httpHost, tlsConfig, HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)tlsConfig.toSSLConnectionSocketFactory()).build());
    }

    SearchGuardRestClient(HttpHost httpHost, TLSConfig tlsConfig, CloseableHttpClient client) {
        this.httpHost = httpHost;
        this.tlsConfig = tlsConfig;
        this.client = client;
    }

    public AuthInfoResponse authInfo() throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        return this.get("/_searchguard/authinfo").parseResponseBy(AuthInfoResponse::new);
    }

    public BasicResponse putConfigBulk(Map<String, Map<String, ?>> configTypeToConfigMap) throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        return this.putJson("/_searchguard/config", configTypeToConfigMap, new Header[0]).parseResponseBy(BasicResponse::new);
    }

    public GetBulkConfigResponse getConfigBulk() throws InvalidResponseException, ServiceUnavailableException, UnauthorizedException, ApiException, FailedConnectionException {
        return this.get("/_searchguard/config").parseResponseBy(GetBulkConfigResponse::new);
    }

    public GetUserResponse getUser(String userName) throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        userName = SearchGuardRestClient.encodeUserName(userName);
        return this.get("/_searchguard/internal_users/" + userName).parseResponseBy(GetUserResponse::new);
    }

    public BasicResponse deleteUser(String userName) throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        userName = SearchGuardRestClient.encodeUserName(userName);
        return this.delete("/_searchguard/internal_users/" + userName).parseResponseBy(BasicResponse::new);
    }

    private static String encodeUserName(String userName) {
        return URLEncoder.encode(userName, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public BasicResponse putUser(String userName, Map<String, Object> newUserData) throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        userName = SearchGuardRestClient.encodeUserName(userName);
        return this.putJson("/_searchguard/internal_users/" + userName, newUserData, new Header[0]).parseResponseBy(BasicResponse::new);
    }

    public BasicResponse patchUser(String userName, DocPatch patch, Header ... headers) throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        userName = SearchGuardRestClient.encodeUserName(userName);
        return this.patch("/_searchguard/internal_users/" + userName, patch, headers).parseResponseBy(BasicResponse::new);
    }

    public BasicResponse putConfigVar(String id, Object value, String scope, boolean encrypt, Header ... headers) throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        doc.put("value", value);
        if (scope != null) {
            doc.put("scope", scope);
        }
        if (encrypt) {
            doc.put("encrypt", true);
        }
        return this.putJson("/_searchguard/config/vars/" + id, doc, headers).parseResponseBy(BasicResponse::new);
    }

    public BasicResponse deleteConfigVar(String id) throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        return this.delete("/_searchguard/config/vars/" + id).parseResponseBy(BasicResponse::new);
    }

    public BasicResponse getAllConfigVars() throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        return this.delete("/_searchguard/config/vars").parseResponseBy(BasicResponse::new);
    }

    public BasicResponse putSgConfig(Map<String, Object> body) throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        return this.putJson("/_searchguard/api/sg_config", body, new Header[0]).parseResponseBy(BasicResponse::new);
    }

    public BasicResponse reloadHttpCerts() throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        return this.post("/_searchguard/api/ssl/http/reloadcerts/").parseResponseBy(BasicResponse::new);
    }

    public BasicResponse reloadTransportCerts() throws InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException {
        return this.post("/_searchguard/api/ssl/transport/reloadcerts/").parseResponseBy(BasicResponse::new);
    }

    public BasicResponse getComponentState(String componentId, boolean verbose) throws InvalidResponseException, ServiceUnavailableException, UnauthorizedException, ApiException, FailedConnectionException {
        return this.get("/_searchguard/component/" + (componentId != null ? componentId : "_all") + "/_health?verbose=" + verbose).parseResponseBy(BasicResponse::new);
    }

    public GetSgLicenseResponse getSgLicense() throws FailedConnectionException, InvalidResponseException, UnauthorizedException, ServiceUnavailableException, ApiException {
        return this.get("/_searchguard/license").parseResponseBy(GetSgLicenseResponse::new);
    }

    public BasicResponse putSgLicense(Map<String, Object> body) throws FailedConnectionException, InvalidResponseException, UnauthorizedException, ServiceUnavailableException, ApiException {
        return this.putJson("/_searchguard/license/key", body, new Header[0]).parseResponseBy(BasicResponse::new);
    }

    public Response get(String path) throws FailedConnectionException, InvalidResponseException {
        try {
            return new Response((HttpResponse)this.client.execute(this.httpHost, (HttpRequest)new HttpGet(path)));
        }
        catch (ClientProtocolException e) {
            throw new FailedConnectionException(e);
        }
        catch (ConnectException e) {
            throw new FailedConnectionException(e.getMessage(), e);
        }
        catch (SSLHandshakeException e) {
            throw new FailedConnectionException("TLS handshake failed while creating new connection: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FailedConnectionException(e);
        }
    }

    public Response post(String path, String body, ContentType contentType) throws FailedConnectionException, InvalidResponseException {
        try {
            HttpPost httpPost = new HttpPost(path);
            httpPost.setEntity((HttpEntity)new StringEntity(body, contentType));
            httpPost.setHeader("Content-Type", contentType.getMimeType());
            return new Response((HttpResponse)this.client.execute(this.httpHost, (HttpRequest)httpPost));
        }
        catch (ClientProtocolException e) {
            throw new FailedConnectionException(e);
        }
        catch (ConnectException e) {
            throw new FailedConnectionException(e.getMessage(), e);
        }
        catch (SSLHandshakeException e) {
            throw new FailedConnectionException("TLS handshake failed while creating new connection: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FailedConnectionException(e);
        }
    }

    protected Response postJson(String path, Map<String, Object> body) throws FailedConnectionException, InvalidResponseException {
        return this.post(path, DocWriter.json().writeAsString(body), ContentType.APPLICATION_JSON);
    }

    public Response post(String path) throws FailedConnectionException, InvalidResponseException {
        try {
            HttpPost httpPost = new HttpPost(path);
            return new Response((HttpResponse)this.client.execute(this.httpHost, (HttpRequest)httpPost));
        }
        catch (ClientProtocolException e) {
            throw new FailedConnectionException(e);
        }
        catch (ConnectException e) {
            throw new FailedConnectionException(e.getMessage(), e);
        }
        catch (SSLHandshakeException e) {
            throw new FailedConnectionException("TLS handshake failed while creating new connection: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FailedConnectionException(e);
        }
    }

    public Response put(String path, String body, ContentType contentType, Header ... headers) throws FailedConnectionException, InvalidResponseException {
        try {
            HttpPut httpPut = new HttpPut(path);
            if (headers != null) {
                httpPut.setHeaders(headers);
            }
            httpPut.setEntity((HttpEntity)new StringEntity(body, contentType));
            return new Response((HttpResponse)this.client.execute(this.httpHost, (HttpRequest)httpPut));
        }
        catch (ClientProtocolException e) {
            throw new FailedConnectionException(e);
        }
        catch (ConnectException e) {
            throw new FailedConnectionException(e.getMessage(), e);
        }
        catch (SSLHandshakeException e) {
            throw new FailedConnectionException("TLS handshake failed while creating new connection: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FailedConnectionException(e);
        }
    }

    protected Response putJson(String path, Map<String, ?> body, Header ... headers) throws FailedConnectionException, InvalidResponseException {
        return this.put(path, DocWriter.json().writeAsString(body), ContentType.APPLICATION_JSON, headers);
    }

    public Response patch(String path, DocPatch patch, Header ... headers) throws FailedConnectionException, InvalidResponseException {
        return this.patch(path, patch.toJsonString(), ContentType.create((String)patch.getMediaType()), headers);
    }

    public Response patch(String path, String body, ContentType contentType, Header ... headers) throws FailedConnectionException, InvalidResponseException {
        try {
            HttpPatch httpPatch = new HttpPatch(path);
            if (headers != null) {
                httpPatch.setHeaders(headers);
            }
            httpPatch.setEntity((HttpEntity)new StringEntity(body, contentType));
            return new Response((HttpResponse)this.client.execute(this.httpHost, (HttpRequest)httpPatch));
        }
        catch (ClientProtocolException e) {
            throw new FailedConnectionException(e);
        }
        catch (ConnectException e) {
            throw new FailedConnectionException(e.getMessage(), e);
        }
        catch (SSLHandshakeException e) {
            throw new FailedConnectionException("TLS handshake failed while creating new connection: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FailedConnectionException(e);
        }
    }

    public Response delete(String path) throws FailedConnectionException, InvalidResponseException {
        try {
            return new Response((HttpResponse)this.client.execute(this.httpHost, (HttpRequest)new HttpDelete(path)));
        }
        catch (ClientProtocolException e) {
            throw new FailedConnectionException(e);
        }
        catch (ConnectException e) {
            throw new FailedConnectionException(e.getMessage(), e);
        }
        catch (SSLHandshakeException e) {
            throw new FailedConnectionException("TLS handshake failed while creating new connection: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FailedConnectionException(e);
        }
    }

    public HttpHost getHttpHost() {
        return this.httpHost;
    }

    public TLSConfig getTlsConfig() {
        return this.tlsConfig;
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getEntityAsString(HttpResponse response) throws IllegalCharsetNameException, UnsupportedCharsetException, IOException {
        if (response == null || response.getEntity() == null) {
            return null;
        }
        return CharStreams.toString((Readable)new InputStreamReader(response.getEntity().getContent(), SearchGuardRestClient.getContentEncoding(response.getEntity())));
    }

    private static Charset getContentEncoding(HttpEntity entity) throws IllegalCharsetNameException, UnsupportedCharsetException {
        return entity.getContentEncoding() != null ? Charset.forName(entity.getContentEncoding().getValue()) : Charsets.UTF_8;
    }

    private static String getContentTypeFromResponse(HttpResponse response) {
        if (response.getEntity() == null) {
            return null;
        }
        Header header = response.getEntity().getContentType();
        if (header == null) {
            return null;
        }
        ContentType contentType = ContentType.parse((String)header.getValue());
        return contentType.getMimeType().toLowerCase();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public SearchGuardRestClient debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public class Response {
        private final HttpResponse httpResponse;
        private final String bodyAsString;
        private final String contentType;
        private final String eTag;
        private final String searchGuardVersion;

        Response(HttpResponse httpResponse) throws InvalidResponseException {
            this.httpResponse = httpResponse;
            this.contentType = SearchGuardRestClient.getContentTypeFromResponse(httpResponse);
            this.eTag = httpResponse.containsHeader("ETag") ? httpResponse.getFirstHeader("ETag").getValue() : null;
            String string = this.searchGuardVersion = httpResponse.containsHeader("X-Search-Guard-Version") ? httpResponse.getFirstHeader("X-Search-Guard-Version").getValue() : null;
            if (SearchGuardRestClient.this.debug) {
                System.out.println("------------------------------------------------");
                System.out.println(this.httpResponse.getStatusLine());
                System.out.println("Content-Type: " + this.contentType);
            }
            try {
                this.bodyAsString = SearchGuardRestClient.getEntityAsString(httpResponse);
                if (SearchGuardRestClient.this.debug && this.bodyAsString != null && this.bodyAsString.length() > 0) {
                    System.out.println(this.abbreviate(this.bodyAsString, 240));
                }
                if (SearchGuardRestClient.this.debug) {
                    System.out.println("------------------------------------------------");
                }
            }
            catch (IOException | IllegalCharsetNameException | UnsupportedCharsetException e) {
                throw new InvalidResponseException(e);
            }
        }

        private String abbreviate(String string, int length) {
            if (string.length() <= length) {
                return string;
            }
            return string.substring(0, length) + "...";
        }

        Map<String, Object> asMap() throws InvalidResponseException, ServiceUnavailableException, UnauthorizedException, ApiException, PreconditionFailedException {
            this.checkStatus();
            try {
                return DocReader.format((Format)Format.getByContentType((String)this.contentType)).readObject(this.bodyAsString);
            }
            catch (DocumentParseException | Format.UnknownDocTypeException | UnexpectedDocumentStructureException e) {
                throw new InvalidResponseException(e);
            }
        }

        public DocNode asDocNode() throws InvalidResponseException {
            if (this.bodyAsString == null) {
                return DocNode.EMPTY;
            }
            try {
                Format docType = Format.peekByContentType((String)this.contentType);
                if (docType != null) {
                    return DocNode.wrap((Object)DocReader.format((Format)docType).read(this.bodyAsString));
                }
                return DocNode.wrap((Object)this.bodyAsString);
            }
            catch (DocumentParseException e) {
                throw new InvalidResponseException(e);
            }
        }

        public <T> T byString(ValidatingFunction<String, T> parser) throws InvalidResponseException, ServiceUnavailableException, UnauthorizedException, ApiException {
            this.checkStatus();
            try {
                return (T)parser.apply((Object)this.bodyAsString);
            }
            catch (ConfigValidationException e) {
                throw new InvalidResponseException(e);
            }
            catch (Exception e) {
                throw new InvalidResponseException(e);
            }
        }

        public <T> T parseResponseBy(ResponseParser<T> parser) throws InvalidResponseException, ServiceUnavailableException, UnauthorizedException, ApiException {
            this.checkStatus();
            try {
                return parser.apply(this);
            }
            catch (ConfigValidationException e) {
                throw new InvalidResponseException(e);
            }
            catch (Exception e) {
                throw new InvalidResponseException(e);
            }
        }

        public HttpResponse getHttpResponse() {
            return this.httpResponse;
        }

        private void checkStatus() throws ServiceUnavailableException, UnauthorizedException, ApiException, InvalidResponseException {
            int statusCode = this.httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 500) {
                String message = this.getStatusMessage("Service unavailable: Internal server error");
                throw new ServiceUnavailableException(message, this.httpResponse.getStatusLine(), this.httpResponse);
            }
            if (statusCode == 503) {
                String message = this.getStatusMessage("Service temporarily unavailable; please try again later");
                throw new ServiceUnavailableException(message, this.httpResponse.getStatusLine(), this.httpResponse);
            }
            if (statusCode >= 500) {
                String message = this.getStatusMessage("Service unavailable: Error " + this.httpResponse.getStatusLine().getStatusCode());
                throw new ServiceUnavailableException(message, this.httpResponse.getStatusLine(), this.httpResponse);
            }
            if (statusCode == 401) {
                String message = this.getStatusMessage("Unauthorized");
                throw new UnauthorizedException(message, this.httpResponse.getStatusLine(), this.httpResponse);
            }
            if (statusCode == 400) {
                if ("application/json".equals(this.contentType)) {
                    throw this.parseBadRequestJsonResponse();
                }
                String message = this.getStatusMessage("Bad Request");
                throw new ApiException(message, this.httpResponse.getStatusLine(), this.httpResponse, this.bodyAsString);
            }
            if (statusCode == 404) {
                String message = this.getStatusMessage("Not found");
                throw new ApiException(message, this.httpResponse.getStatusLine(), this.httpResponse, this.bodyAsString);
            }
            if (statusCode == 412) {
                String message = this.getStatusMessage("Precondition failed");
                throw new PreconditionFailedException(message, this.httpResponse.getStatusLine(), this.httpResponse, this.bodyAsString);
            }
            if (statusCode > 400) {
                String message = this.getStatusMessage("Bad Request");
                throw new ApiException(message, this.httpResponse.getStatusLine(), this.httpResponse, this.bodyAsString);
            }
        }

        private String getStatusMessage(String fallback) {
            String message;
            if ("application/json".equals(this.contentType)) {
                try {
                    Object document = DocReader.json().read(this.bodyAsString);
                    if (document instanceof Map) {
                        Object error = ((Map)document).get("error");
                        if (error instanceof String) {
                            return (String)error;
                        }
                        if (error instanceof Map && ((Map)error).get("message") instanceof String) {
                            return (String)((Map)error).get("message");
                        }
                        Object message2 = ((Map)document).get("message");
                        if (message2 != null) {
                            return message2.toString();
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Error while parsing JSON response", e);
                }
            }
            if ((message = this.httpResponse.getStatusLine().getReasonPhrase()) != null && message.length() != 0) {
                return message;
            }
            return fallback;
        }

        private ApiException parseBadRequestJsonResponse() throws InvalidResponseException {
            try {
                DocNode response = DocNode.wrap((Object)DocReader.json().read(this.bodyAsString));
                String errorMessage = null;
                ValidationErrors validationErrors = null;
                if (response.get("error") instanceof String) {
                    errorMessage = (String)response.get("error");
                } else if (response.get("error") instanceof Map) {
                    DocNode errorNode = response.getAsNode("error");
                    if (errorNode.get("reason") instanceof String && (errorMessage = (String)errorNode.get("reason")).startsWith("Invalid index name [_searchguard]")) {
                        errorMessage = "Invalid REST endpoint";
                    }
                    if (errorNode.get("message") instanceof String) {
                        errorMessage = (String)errorNode.get("message");
                    }
                    if (errorNode.get("details") instanceof Map) {
                        try {
                            validationErrors = ValidationErrors.parse((Map)DocUtils.toStringKeyedMap((Map)((Map)errorNode.get("details"))));
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Error while parsing validation errors in response", e);
                        }
                    }
                }
                if (response.get("detail") instanceof Map) {
                    try {
                        validationErrors = ValidationErrors.parse((Map)DocUtils.toStringKeyedMap((Map)((Map)response.get("detail"))));
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error while parsing validation errors in response", e);
                    }
                }
                if (errorMessage == null) {
                    errorMessage = this.httpResponse.getStatusLine().toString();
                }
                return new ApiException(errorMessage, this.httpResponse.getStatusLine(), this.httpResponse, this.bodyAsString).validationErrors(validationErrors);
            }
            catch (DocumentParseException e) {
                throw new InvalidResponseException("Response contains invalid JSON: " + e.getMessage(), e);
            }
        }

        public String getETag() {
            return this.eTag;
        }

        public String getSearchGuardVersion() {
            return this.searchGuardVersion;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    @FunctionalInterface
    public static interface ResponseParser<R> {
        public R apply(Response var1) throws InvalidResponseException, ConfigValidationException, ApiException;
    }
}

