/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands.user;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.documents.patch.MergePatch;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.ConditionalRequestHeader;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.client.api.GetUserResponse;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="update-user", description={"Updates a user"})
public class UpdateUser
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="1", description={"User name"})
    private String userName;
    @CommandLine.Option(names={"-r", "--sg-roles"}, split=",")
    private List<String> sgRolesToAdd;
    @CommandLine.Option(names={"--remove-sg-roles"}, split=",")
    private List<String> sgRolesToRemove;
    @CommandLine.Option(names={"--backend-roles"}, split=",")
    private List<String> backendRolesToAdd;
    @CommandLine.Option(names={"--remove-backend-roles"}, split=",")
    private List<String> backendRolesToRemove;
    @CommandLine.Option(names={"-a", "--attributes"}, split=",")
    private Map<String, Object> attributesToAdd;
    @CommandLine.Option(names={"--remove-attributes"}, split=",")
    private List<String> attributesToRemove;
    @CommandLine.Option(names={"--password"}, arity="0..1", description={"Passphrase"}, interactive=true)
    String password;

    @Override
    public Integer call() {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            this.retryOnConcurrencyConflict(() -> {
                GetUserResponse getUserResponse = client.getUser(this.userName);
                LinkedHashMap<String, Object> userMergePatch = new LinkedHashMap<String, Object>();
                StringBuilder messageBuilder = new StringBuilder();
                messageBuilder.append("Updating user ").append(this.userName);
                if (this.sgRolesToAdd != null || this.sgRolesToRemove != null) {
                    ArrayList<String> sgRoles = new ArrayList<String>(getUserResponse.getSearchGuardRoles());
                    if (this.sgRolesToRemove != null) {
                        messageBuilder.append(" with SG roles to remove: ").append(String.join((CharSequence)",", this.sgRolesToRemove));
                        sgRoles.removeAll(this.sgRolesToRemove);
                    }
                    if (this.sgRolesToAdd != null) {
                        messageBuilder.append(" with SG roles: ").append(String.join((CharSequence)",", this.sgRolesToAdd));
                        sgRoles.addAll(this.sgRolesToAdd);
                    }
                    if (!sgRoles.equals(getUserResponse.getSearchGuardRoles())) {
                        userMergePatch.put("search_guard_roles", sgRoles);
                    }
                }
                if (this.backendRolesToAdd != null || this.backendRolesToRemove != null) {
                    ArrayList<String> backendRoles = new ArrayList<String>(getUserResponse.getBackendRoles());
                    if (this.backendRolesToRemove != null) {
                        messageBuilder.append(" with backend roles to remove: ").append(String.join((CharSequence)",", this.backendRolesToRemove));
                        backendRoles.removeAll(this.backendRolesToRemove);
                    }
                    if (this.backendRolesToAdd != null) {
                        messageBuilder.append(" with backend roles: ").append(String.join((CharSequence)",", this.backendRolesToAdd));
                        backendRoles.addAll(this.backendRolesToAdd);
                    }
                    if (!backendRoles.equals(getUserResponse.getBackendRoles())) {
                        userMergePatch.put("backend_roles", backendRoles);
                    }
                }
                if (this.attributesToAdd != null || this.attributesToRemove != null) {
                    LinkedHashMap attributesPatch = new LinkedHashMap();
                    if (this.attributesToRemove != null) {
                        messageBuilder.append(" with attributes to remove: ").append(String.join((CharSequence)",", this.attributesToRemove));
                        for (String string : this.attributesToRemove) {
                            attributesPatch.put(string, null);
                        }
                    }
                    if (this.attributesToAdd != null) {
                        messageBuilder.append(" with attributes: ").append(this.attributesToAdd.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + String.valueOf(entry.getValue())).collect(Collectors.joining(",")));
                        for (Map.Entry entry2 : this.attributesToAdd.entrySet()) {
                            attributesPatch.put((String)entry2.getKey(), entry2.getValue());
                        }
                    }
                    userMergePatch.put("attributes", DocNode.wrap(attributesPatch).splitDottedAttributeNamesToTree().toMap());
                }
                if (this.password != null) {
                    userMergePatch.put("password", this.password);
                    messageBuilder.append(" with a new password");
                }
                if (this.verbose || this.debug) {
                    System.out.println(messageBuilder);
                }
                BasicResponse basicResponse = client.patchUser(this.userName, (DocPatch)new MergePatch(DocNode.wrap(userMergePatch)), new ConditionalRequestHeader.IfMatch(getUserResponse.getETag()));
                System.out.println(basicResponse.getMessage());
            });
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (UnexpectedDocumentStructureException | SgctlException | FailedConnectionException | InvalidResponseException | ServiceUnavailableException | UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                if (e.getValidationErrors() != null) {
                    System.err.println(e.getValidationErrors());
                } else {
                    System.err.println(e.getMessage());
                }
                return 1;
            }
        }
    }
}

