/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.client;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeader;

public interface ConditionalRequestHeader
extends Header {
    public Header toHeader();

    default public HeaderElement[] getElements() throws ParseException {
        return this.toHeader().getElements();
    }

    default public String getName() {
        return this.toHeader().getName();
    }

    default public String getValue() {
        return this.toHeader().getValue();
    }

    public static class IfMatch
    implements ConditionalRequestHeader {
        private final String value;

        public IfMatch(String value) {
            this.value = value;
        }

        @Override
        public Header toHeader() {
            return new BasicHeader("If-Match", this.value);
        }
    }

    public static class IfNoneMatch
    implements ConditionalRequestHeader {
        private final String value;

        public IfNoneMatch(String value) {
            this.value = value;
        }

        @Override
        public Header toHeader() {
            return new BasicHeader("If-None-Match", this.value);
        }
    }
}

