/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.documents.patch.SimplePathPatch;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Modifies a property in the Search Guard Configuration"})
public class SetCommand
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Type of the configuration to be modified. Example: authc"})
    String configType;
    @CommandLine.Parameters(index="1", description={"Path to the property to the modified. Example: network.trusted_proxies"})
    String propertyPath;
    @CommandLine.Parameters(index="2", arity="0..1", description={"Set the property to the given string value"})
    String value;
    @CommandLine.Option(names={"-n", "--numeric-value"}, description={"Set the property to the given numeric value"})
    Number numericValue;
    @CommandLine.Option(names={"--true"}, description={"Set the property to the boolean value true"})
    boolean booleanTrue;
    @CommandLine.Option(names={"--false"}, description={"Set the property to the boolean value false"})
    boolean booleanFalse;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() throws Exception {
        try (SearchGuardRestClient client = this.getClient().debug(this.debug);){
            Boolean value;
            Boolean bl = this.booleanTrue ? Boolean.TRUE : (this.booleanFalse ? Boolean.FALSE : (value = this.numericValue != null ? this.numericValue : this.value));
            if (value == null) {
                System.err.println("Value is missing");
                Integer n = 1;
                return n;
            }
            SimplePathPatch docPatch = new SimplePathPatch(new SimplePathPatch.Operation[]{new SimplePathPatch.Operation(this.propertyPath, (Object)value)});
            BasicResponse basicResponse = client.patch("/_searchguard/config/" + this.configType, (DocPatch)docPatch, new Header[0]).parseResponseBy(BasicResponse::new);
            System.out.println(basicResponse.getMessage());
            Integer n = 0;
            return n;
        }
        catch (SgctlException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (InvalidResponseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (FailedConnectionException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (ServiceUnavailableException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (UnauthorizedException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (ApiException e) {
            if (e.getValidationErrors() != null) {
                System.err.println("Modified configuration is not valid. Update rejected.\n" + e.getValidationErrors().toString());
                return 1;
            }
            System.err.println(e.getMessage());
            return 1;
        }
    }
}

