/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.client.api.GetSgLicenseResponse;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="update-license", description={"Updates the SG license"})
public class UpdateSgLicense
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-l", "--license"}, required=true, description={"Path to the license file"})
    File licenseFile;

    @Override
    public Integer call() throws Exception {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            String licenseString = Files.asCharSource((File)this.licenseFile, (Charset)StandardCharsets.UTF_8).read();
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("key", licenseString);
            BasicResponse response = client.putSgLicense(body);
            System.out.println(response.getMessage());
            GetSgLicenseResponse getResponse = client.getSgLicense();
            System.out.println("Success. This license will expire on " + getResponse.getExpiryString());
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException | FailedConnectionException | InvalidResponseException | ServiceUnavailableException | UnauthorizedException | IOException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                if (e.getValidationErrors() != null) {
                    System.err.println(e.getValidationErrors());
                } else {
                    System.err.println(e.getMessage());
                }
                return 1;
            }
        }
    }
}

