/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.FileDoesNotExist;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.PreconditionFailedException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.client.api.ConfigType;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="update-config", description={"Updates Search Guard configuration on the server from local files"})
public class UpdateConfig
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(arity="1..*", description={"Search Guard configuration files like sg_authc.yml or a directory containing these files"})
    List<File> files;
    @CommandLine.Option(names={"-f", "--force"}, arity="0..1", description={"Upload the configuration even if a concurrent modification is detected"})
    boolean force;
    private static final Pattern ETAG_HEADER_PATTERN = Pattern.compile("^#\\s*.*etag:([a-z0-9\\.]+)");
    private static final Pattern CLUSTER_HEADER_PATTERN = Pattern.compile("^#\\s*.*cluster:(\\S+)");

    @Override
    public Integer call() {
        HashMap<String, String> configTypeToFileMap = new HashMap<String, String>();
        LinkedHashMap configTypeToConfigMap = new LinkedHashMap();
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            if (this.files.size() == 1 && this.files.get(0).isDirectory()) {
                File dir = this.files.get(0);
                this.files = Arrays.asList(Objects.requireNonNull(dir.listFiles()));
                ArrayList ignoredFiles = new ArrayList();
                this.files = this.files.stream().filter(file -> {
                    if (file.getName().startsWith("sg_") && file.getName().endsWith(".yml")) {
                        return true;
                    }
                    ignoredFiles.add(file);
                    return false;
                }).collect(Collectors.toList());
                if (ignoredFiles.size() == 1) {
                    System.err.println("File " + ((File)ignoredFiles.get(0)).getName() + " does not seem to be a Search Guard configuration file. Ignoring it");
                } else if (ignoredFiles.size() > 1) {
                    System.err.println("Files " + ignoredFiles.stream().map(File::getName).collect(Collectors.joining(", ")) + " do not seem to be Search Guard configuration files. Ignoring these");
                }
                if (this.files.size() == 0) {
                    throw new SgctlException("Directory " + String.valueOf(dir) + " does not contain any configuration files");
                }
                if (this.verbose || this.debug) {
                    System.out.println("Uploading config files from directory " + dir.getAbsolutePath() + ": " + this.files.stream().map(File::getName).collect(Collectors.joining(", ")));
                }
            } else if (this.verbose || this.debug) {
                System.out.println("Uploading config files: " + this.files.stream().map(File::getName).collect(Collectors.joining(", ")));
            }
            for (File file2 : this.files) {
                try {
                    Format format = Format.getByFileName((String)file2.getName(), (Format)Format.YAML);
                    String rawContent = Files.asCharSource((File)file2, (Charset)Charsets.UTF_8).read();
                    DocNode content = DocNode.wrap((Object)DocReader.format((Format)format).fallbackForEmptyDocuments((Object)ImmutableMap.empty()).readObject(file2));
                    ConfigType configType = ConfigType.getFor(file2, content, rawContent);
                    String etag = this.force ? null : this.getETag(rawContent);
                    String clusterName = this.getClusterName(rawContent);
                    if (!this.force && clusterName != null && this.getConnectedClusterName() != null && !clusterName.equals(this.getConnectedClusterName())) {
                        this.validationErrors.add(new ValidationError(file2.getPath(), "The file is designated for the cluster " + clusterName + ", but we are connected to the cluster " + this.getConnectedClusterName() + ". Use the --force switch to write the configuration to " + this.getConnectedClusterName()));
                    }
                    if (!configTypeToConfigMap.containsKey(configType.getApiName())) {
                        configTypeToConfigMap.put(configType.getApiName(), (Map<String, ?>)(etag != null ? OrderedImmutableMap.of((Object)"content", (Object)content, (Object)"etag", (Object)etag) : OrderedImmutableMap.of((Object)"content", (Object)content)));
                        configTypeToFileMap.put(configType.getApiName(), file2.getPath());
                        continue;
                    }
                    this.validationErrors.add(new ValidationError(file2.getPath(), "Configuration of type " + configType.getApiName() + " is already specifed in file " + (String)configTypeToFileMap.get(configType.getApiName())));
                }
                catch (FileNotFoundException e) {
                    this.validationErrors.add((ValidationError)new FileDoesNotExist(file2.getPath(), file2));
                }
                catch (JsonProcessingException e) {
                    this.validationErrors.add(new ValidationError(file2.getPath(), e.getMessage()).cause((Throwable)e));
                }
                catch (IOException e) {
                    this.validationErrors.add(new ValidationError(file2.getPath(), "Error while reading: " + String.valueOf(e)).cause((Throwable)e));
                }
                catch (ConfigValidationException e) {
                    this.validationErrors.add(file2.getPath(), e);
                }
            }
            this.validationErrors.throwExceptionForPresentErrors();
            BasicResponse basicResponse = client.putConfigBulk(configTypeToConfigMap);
            System.out.println(basicResponse.getMessage());
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable basicResponse) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        basicResponse.addSuppressed(throwable);
                    }
                }
                throw basicResponse;
            }
            catch (ConfigValidationException e) {
                System.err.println("Invalid config files:\n" + String.valueOf(e.getValidationErrors()));
                return 1;
            }
            catch (SgctlException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (InvalidResponseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (FailedConnectionException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ServiceUnavailableException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (PreconditionFailedException e) {
                System.err.println(e.getMessage());
                System.err.println("Use the --force switch to overwrite any concurrent change");
                return 1;
            }
            catch (ApiException e) {
                if (e.getValidationErrors() != null) {
                    Map validationErrorsByFile = e.getValidationErrors().groupByKeys(configTypeToFileMap);
                    System.err.println("Invalid config files:\n");
                    for (Map.Entry entry : validationErrorsByFile.entrySet()) {
                        System.err.println((String)entry.getKey() + ":");
                        System.err.println(((ValidationErrors)entry.getValue()).toString().replaceAll("(?m)^", "  "));
                        System.err.println();
                    }
                } else {
                    System.err.println(e.getMessage());
                }
                return 1;
            }
        }
    }

    private String getETag(String rawContent) {
        Matcher matcher = ETAG_HEADER_PATTERN.matcher(rawContent);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getClusterName(String rawContent) {
        Matcher matcher = CLUSTER_HEADER_PATTERN.matcher(rawContent);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

