/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands.special.multitenancy.datamigration880;

import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="get-mt-data-migration-state-from-8.7", description={"Gets state of multi-tenancy data migration from Kibana 8.7 to 8.8"})
public class GetMultiTenancyDataMigrationState
extends ConnectingCommand
implements Callable<Integer> {
    private static final String ENDPOINT_PATH = "/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0";

    @Override
    public Integer call() {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            if (this.debug || this.verbose) {
                System.out.println("Getting state of multi-tenancy data migration from Kibana 8.7 to 8.8");
            }
            BasicResponse response = client.get(ENDPOINT_PATH).parseResponseBy(BasicResponse::new);
            System.out.println(response.toPrettyJsonString());
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException | ApiException | FailedConnectionException | InvalidResponseException | ServiceUnavailableException | UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
    }
}

