/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config;

import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.jobs.cluster.JobDistributor;
import com.floragunn.searchsupport.jobs.config.JobConfig;
import com.floragunn.searchsupport.jobs.config.JobConfigFactory;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class IndexJobConfigSource<JobType extends JobConfig>
implements Iterable<JobType> {
    private static final Logger log = LogManager.getLogger(IndexJobConfigSource.class);
    private final String indexName;
    private final Client client;
    private final JobConfigFactory<JobType> jobFactory;
    private final JobDistributor jobDistributor;
    private final QueryBuilder query;

    public IndexJobConfigSource(String indexName, Client client, JobConfigFactory<JobType> jobFactory, JobDistributor jobDistributor) {
        this(indexName, null, client, jobFactory, jobDistributor);
    }

    public IndexJobConfigSource(String indexName, QueryBuilder query, Client client, JobConfigFactory<JobType> jobFactory, JobDistributor jobDistributor) {
        this.indexName = indexName;
        this.client = client;
        this.jobFactory = jobFactory;
        this.jobDistributor = jobDistributor;
        this.query = query != null ? query : QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"active", (boolean)false));
    }

    @Override
    public Iterator<JobType> iterator() {
        return new IndexJobConfigIterator();
    }

    public String toString() {
        return "IndexJobConfigSource [indexName=" + this.indexName + ", jobFactory=" + this.jobFactory + ", jobDistributor=" + this.jobDistributor + "]";
    }

    private class IndexJobConfigIterator
    implements Iterator<JobType> {
        private Iterator<SearchHit> searchHitIterator;
        private SearchRequest searchRequest;
        private SearchResponse searchResponse;
        private SearchHits searchHits;
        private JobType current;
        private boolean done = false;
        private int loaded = 0;
        private int filtered = 0;

        private IndexJobConfigIterator() {
        }

        @Override
        public boolean hasNext() {
            this.lazyInit();
            return this.current != null;
        }

        @Override
        public JobType next() {
            this.lazyInit();
            Object result = this.current;
            this.current = null;
            return result;
        }

        private void lazyInit() {
            if (this.done) {
                return;
            }
            if (this.searchRequest == null) {
                try {
                    this.searchRequest = new SearchRequest(new String[]{IndexJobConfigSource.this.indexName});
                    this.searchRequest.source(new SearchSourceBuilder().query(IndexJobConfigSource.this.query).size(1000).version(Boolean.valueOf(true)));
                    this.searchRequest.scroll(new TimeValue(10000L));
                    if (log.isDebugEnabled()) {
                        log.debug("Executing " + this.searchRequest);
                    }
                    this.searchResponse = (SearchResponse)IndexJobConfigSource.this.client.search(this.searchRequest).actionGet();
                    this.searchHits = this.searchResponse.getHits();
                    this.searchHitIterator = this.searchHits.iterator();
                }
                catch (IndexNotFoundException e) {
                    this.done = true;
                    return;
                }
            }
            while (this.current == null && this.searchHits.getTotalHits().value != 0L) {
                if (!this.searchHitIterator.hasNext()) {
                    this.searchResponse = (SearchResponse)IndexJobConfigSource.this.client.prepareSearchScroll(this.searchResponse.getScrollId()).setScroll(new TimeValue(10000L)).execute().actionGet();
                    this.searchHits = this.searchResponse.getHits();
                    this.searchHitIterator = this.searchHits.iterator();
                    if (!this.searchHitIterator.hasNext()) break;
                }
                SearchHit searchHit = this.searchHitIterator.next();
                try {
                    Object job = IndexJobConfigSource.this.jobFactory.createFromBytes(searchHit.getId(), searchHit.getSourceRef(), searchHit.getVersion());
                    if (IndexJobConfigSource.this.jobDistributor == null || IndexJobConfigSource.this.jobDistributor.isJobSelected((JobConfig)job)) {
                        this.current = job;
                        ++this.loaded;
                        continue;
                    }
                    ++this.filtered;
                }
                catch (ConfigValidationException e) {
                    log.error("Error while parsing job config " + IndexJobConfigSource.this.indexName + "/" + searchHit.getId() + ":\n\n" + searchHit.getSourceAsString() + "\n\n" + e.getValidationErrors(), (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Error while parsing job config " + IndexJobConfigSource.this.indexName + "/" + searchHit.getId() + ":\n\n" + searchHit.getSourceAsString(), (Throwable)e);
                }
            }
            if (this.current == null) {
                this.done = true;
                if (log.isDebugEnabled()) {
                    log.debug("Loaded jobs from " + IndexJobConfigSource.this.indexName + ": " + this.loaded + "; filtered: " + this.filtered);
                }
            }
        }
    }
}

