/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config.schedule.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.MissingAttribute;
import com.floragunn.searchsupport.config.validation.ValidationError;
import com.floragunn.searchsupport.config.validation.ValidationErrors;
import com.floragunn.searchsupport.jobs.config.schedule.elements.HumanReadableCronTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.TriggerFactory;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.impl.triggers.CronTriggerImpl;

public class DailyTrigger
extends HumanReadableCronTrigger<DailyTrigger> {
    private static final long serialVersionUID = 8163341554630381366L;
    private List<TimeOfDay> at;
    public static final TriggerFactory<DailyTrigger> FACTORY = new TriggerFactory<DailyTrigger>(){

        @Override
        public String getType() {
            return "daily";
        }

        @Override
        public DailyTrigger create(JsonNode jsonNode, TimeZone timeZone) throws ConfigValidationException {
            return DailyTrigger.create(jsonNode, timeZone);
        }
    };

    public DailyTrigger(List<TimeOfDay> at, TimeZone timeZone) {
        this.at = Collections.unmodifiableList(at);
        this.timeZone = timeZone;
        this.init();
    }

    public ScheduleBuilder<DailyTrigger> getScheduleBuilder() {
        return null;
    }

    @Override
    protected List<CronTriggerImpl> buildCronTriggers() {
        ArrayList<CronTriggerImpl> result = new ArrayList<CronTriggerImpl>();
        for (TimeOfDay timeOfDay : this.at) {
            CronTriggerImpl cronTigger = (CronTriggerImpl)CronScheduleBuilder.cronSchedule((CronExpression)DailyTrigger.createCronExpression(timeOfDay)).build();
            result.add(cronTigger);
        }
        return result;
    }

    public List<TimeOfDay> getAt() {
        return this.at;
    }

    public void setAt(List<TimeOfDay> at) {
        this.at = at;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.at.size() == 1) {
            builder.field("at", DailyTrigger.format(this.at.get(0)));
        } else {
            builder.startArray("at");
            for (TimeOfDay timeOfDay : this.at) {
                builder.value(DailyTrigger.format(timeOfDay));
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public static DailyTrigger create(JsonNode jsonNode, TimeZone timeZone) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        List<Object> at = null;
        try {
            JsonNode atNode = jsonNode.get("at");
            if (atNode != null && atNode.isArray()) {
                at = new ArrayList(atNode.size());
                for (JsonNode atNodeElement : atNode) {
                    at.add(DailyTrigger.parseTimeOfDay(atNodeElement.textValue()));
                }
            } else if (atNode != null && atNode.isTextual()) {
                at = Collections.singletonList(DailyTrigger.parseTimeOfDay(atNode.textValue()));
            } else {
                validationErrors.add((ValidationError)new MissingAttribute("at", jsonNode));
            }
        }
        catch (ConfigValidationException e) {
            validationErrors.add("at", e);
        }
        validationErrors.throwExceptionForPresentErrors();
        return new DailyTrigger(at, timeZone);
    }

    private static CronExpression createCronExpression(TimeOfDay timeOfDay) {
        try {
            StringBuilder result = new StringBuilder();
            result.append(timeOfDay.getSecond()).append(' ');
            result.append(timeOfDay.getMinute()).append(' ');
            result.append(timeOfDay.getHour()).append(' ');
            result.append("? * *");
            return new CronExpression(result.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

