/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config.schedule.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.InvalidAttributeValue;
import com.floragunn.searchsupport.config.validation.MissingAttribute;
import com.floragunn.searchsupport.config.validation.ValidatingJsonNode;
import com.floragunn.searchsupport.config.validation.ValidationError;
import com.floragunn.searchsupport.config.validation.ValidationErrors;
import com.floragunn.searchsupport.jobs.config.schedule.elements.HumanReadableCronTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.TriggerFactory;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.CronTriggerImpl;

public class HourlyTrigger
extends HumanReadableCronTrigger<HourlyTrigger> {
    private static final long serialVersionUID = 8269041855326041719L;
    private List<Integer> minute;
    public static final TriggerFactory<HourlyTrigger> FACTORY = new TriggerFactory<HourlyTrigger>(){

        @Override
        public String getType() {
            return "hourly";
        }

        @Override
        public HourlyTrigger create(JsonNode jsonNode, TimeZone timeZone) throws ConfigValidationException {
            return HourlyTrigger.create(jsonNode, timeZone);
        }
    };

    public HourlyTrigger(List<Integer> minute, TimeZone timeZone) {
        this.minute = Collections.unmodifiableList(minute);
        this.timeZone = timeZone;
        this.init();
    }

    public ScheduleBuilder<HourlyTrigger> getScheduleBuilder() {
        return null;
    }

    @Override
    protected List<CronTriggerImpl> buildCronTriggers() {
        return Collections.singletonList((CronTriggerImpl)CronScheduleBuilder.cronSchedule((CronExpression)HourlyTrigger.createCronExpression(this.minute)).build());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.minute.size() == 1) {
            builder.field("minute", this.minute.get(0));
        } else {
            builder.startArray("minute");
            for (Integer m : this.minute) {
                builder.value(m);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public static HourlyTrigger create(JsonNode jsonNode, TimeZone timeZone) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingJsonNode vJsonNode = new ValidatingJsonNode(jsonNode, validationErrors);
        List<Integer> minute = null;
        try {
            JsonNode minuteNode = vJsonNode.get("minute");
            if (minuteNode != null && minuteNode.isArray()) {
                minute = new ArrayList<Integer>(minuteNode.size());
                for (JsonNode minuteNodeElement : minuteNode) {
                    minute.add(HourlyTrigger.parseMinute(minuteNodeElement));
                }
            } else if (minuteNode != null) {
                minute = Collections.singletonList(HourlyTrigger.parseMinute(minuteNode));
            } else {
                validationErrors.add((ValidationError)new MissingAttribute("minute", jsonNode));
            }
        }
        catch (ConfigValidationException e) {
            validationErrors.add("minute", e);
        }
        vJsonNode.validateUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return new HourlyTrigger(minute, timeZone);
    }

    private static int parseMinute(JsonNode minuteNode) throws ConfigValidationException {
        if (!minuteNode.isNumber()) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)minuteNode.textValue(), (Object)"number between 0 and 59"));
        }
        int result = minuteNode.asInt();
        if (result < 0 || result > 59) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)minuteNode.textValue(), (Object)"number between 0 and 59"));
        }
        return result;
    }

    private static CronExpression createCronExpression(List<Integer> minutes) {
        try {
            StringBuilder result = new StringBuilder();
            result.append("0").append(' ');
            result.append(Strings.join(minutes, (char)',')).append(' ');
            result.append("* ? * *");
            return new CronExpression(result.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getMinute() {
        return this.minute;
    }

    public void setMinute(List<Integer> minute) {
        this.minute = minute;
    }
}

