/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config.schedule.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.InvalidAttributeValue;
import com.floragunn.searchsupport.config.validation.MissingAttribute;
import com.floragunn.searchsupport.config.validation.ValidationError;
import com.floragunn.searchsupport.config.validation.ValidationErrors;
import com.floragunn.searchsupport.jobs.config.schedule.elements.HumanReadableCronTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.TriggerFactory;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.impl.triggers.CronTriggerImpl;

public class MonthlyTrigger
extends HumanReadableCronTrigger<MonthlyTrigger> {
    private static final long serialVersionUID = -6518785696829462600L;
    private List<Integer> on;
    private List<TimeOfDay> at;
    public static final TriggerFactory<MonthlyTrigger> FACTORY = new TriggerFactory<MonthlyTrigger>(){

        @Override
        public String getType() {
            return "monthly";
        }

        @Override
        public MonthlyTrigger create(JsonNode jsonNode, TimeZone timeZone) throws ConfigValidationException {
            return MonthlyTrigger.create(jsonNode, timeZone);
        }
    };

    public MonthlyTrigger(List<Integer> on, List<TimeOfDay> at, TimeZone timeZone) {
        this.on = Collections.unmodifiableList(on);
        this.at = Collections.unmodifiableList(at);
        this.timeZone = timeZone;
        this.init();
    }

    public ScheduleBuilder<MonthlyTrigger> getScheduleBuilder() {
        return null;
    }

    @Override
    protected List<CronTriggerImpl> buildCronTriggers() {
        ArrayList<CronTriggerImpl> result = new ArrayList<CronTriggerImpl>();
        for (TimeOfDay timeOfDay : this.at) {
            CronTriggerImpl cronTigger = (CronTriggerImpl)CronScheduleBuilder.cronSchedule((CronExpression)MonthlyTrigger.createCronExpression(timeOfDay, this.on)).build();
            result.add(cronTigger);
        }
        return result;
    }

    public List<Integer> getOn() {
        return this.on;
    }

    public void setOn(List<Integer> on) {
        this.on = on;
    }

    public List<TimeOfDay> getAt() {
        return this.at;
    }

    public void setAt(List<TimeOfDay> at) {
        this.at = at;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.on.size() == 1) {
            builder.field("on", this.on.get(0));
        } else {
            builder.array("on", new Object[]{this.on});
        }
        if (this.at.size() == 1) {
            builder.field("at", MonthlyTrigger.format(this.at.get(0)));
        } else {
            builder.startArray("at");
            for (TimeOfDay timeOfDay : this.at) {
                builder.value(MonthlyTrigger.format(timeOfDay));
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public static MonthlyTrigger create(JsonNode jsonNode, TimeZone timeZone) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        List<Integer> on = null;
        List<Object> at = null;
        JsonNode onNode = jsonNode.get("on");
        if (onNode != null && onNode.isArray()) {
            on = new ArrayList(onNode.size());
            for (JsonNode onNodeElement : onNode) {
                on.add(MonthlyTrigger.getDayOfMonth(onNodeElement, validationErrors));
            }
        } else {
            on = onNode != null && onNode.isNumber() ? Collections.singletonList(MonthlyTrigger.getDayOfMonth(onNode, validationErrors)) : Collections.emptyList();
        }
        try {
            JsonNode atNode = jsonNode.get("at");
            if (atNode != null && atNode.isArray()) {
                at = new ArrayList(atNode.size());
                for (JsonNode atNodeElement : atNode) {
                    at.add(MonthlyTrigger.parseTimeOfDay(atNodeElement.textValue()));
                }
            } else if (atNode != null && atNode.isTextual()) {
                at = Collections.singletonList(MonthlyTrigger.parseTimeOfDay(atNode.textValue()));
            } else {
                validationErrors.add((ValidationError)new MissingAttribute("at", jsonNode));
            }
        }
        catch (ConfigValidationException e) {
            validationErrors.add("at", e);
        }
        return new MonthlyTrigger(on, at, timeZone);
    }

    private static int getDayOfMonth(JsonNode onNodeElement, ValidationErrors validationErrors) {
        if (onNodeElement.isNumber()) {
            int onValue = onNodeElement.asInt();
            if (onValue < 1 || onValue > 31) {
                validationErrors.add((ValidationError)new InvalidAttributeValue("on", (Object)onValue, (Object)"Day of Month: 1-31", onNodeElement));
            }
            return onValue;
        }
        validationErrors.add((ValidationError)new InvalidAttributeValue("on", (Object)onNodeElement.toString(), (Object)"Day of Month: 1-31", onNodeElement));
        return -1;
    }

    private static CronExpression createCronExpression(TimeOfDay timeOfDay, List<Integer> on) {
        try {
            StringBuilder result = new StringBuilder();
            result.append(timeOfDay.getSecond()).append(' ');
            result.append(timeOfDay.getMinute()).append(' ');
            result.append(timeOfDay.getHour()).append(' ');
            if (on.size() == 0) {
                result.append("*");
            } else {
                boolean first = true;
                for (Integer dayOfMonth : on) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(",");
                    }
                    result.append(dayOfMonth);
                }
            }
            result.append(" * ?");
            return new CronExpression(result.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

